package stream

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSegment(t *testing.T) {
	assert.EqualValues(t, 1, Segment{Origin, Position(1)}.Distance())
	assert.EqualValues(t, 0, Segment{Position(1), Origin}.Distance())

	seg, found := Segment{Origin, Position(1)}.Missing(Origin)
	assert.False(t, found)
	assert.Equal(t, Empty, seg)

	seg, found = Segment{Origin, Position(1)}.Missing(Position(1))
	assert.False(t, found)
	assert.Equal(t, Empty, seg)

	seg, found = Segment{Position(1), Position(2)}.Missing(Origin)
	assert.True(t, found)
	assert.Equal(t, Segment{Origin, Position(1)}, seg)
}

func TestToSegment(t *testing.T) {
	assert.Equal(t, Position(1).AsDelta(), Position(1).ToSegment(true))
	assert.Equal(t, Position(1).AsKeyFrame(), Position(1).ToSegment(false))
}
