package stream

// A Topic is extracted from an Audience (*remote) so that ServerLogic (Source or Threshold)
// can perform a sequence of updates without needing to resolve the destination each time.
//
// Topic is implemented by audience.(*channel). Unlike a Listener,
// each topic refers to a single concrete Address with a single SourceID/Position.
type Topic interface {
	Address() Address
	Current() (SourceID, Position)
	Send(src SourceID, at Segment, data []byte) error
	Forward(Message) error
	Close(err error) error
}
