package stream

import (
	"code.justin.tv/devhub/e2ml/libs/promise"
)

type TrackerPromise interface {
	promise.Any
	Result() (Tracker, error)
}

type MutableTrackerPromise interface {
	TrackerPromise
	Set(Tracker, error) MutableTrackerPromise
}

func NewTrackerPromise() MutableTrackerPromise {
	return &asyncTracker{src: promise.NewAny()}
}

func NewSyncTrackerPromise(result Tracker, err error) TrackerPromise {
	return &syncTracker{result, err}
}

type syncTracker struct {
	result Tracker
	err    error
}

func (s *syncTracker) WouldBlock() bool          { return false }
func (s *syncTracker) Get() (interface{}, error) { return s.result, s.err }
func (s *syncTracker) Result() (Tracker, error)  { return s.result, s.err }

type asyncTracker struct {
	src promise.MutableAny
}

func (a *asyncTracker) WouldBlock() bool          { return a.src.WouldBlock() }
func (a *asyncTracker) Get() (interface{}, error) { return a.src.Get() }
func (a *asyncTracker) Result() (Tracker, error) {
	result, err := a.src.Get()
	if cast, ok := result.(Tracker); ok {
		return cast, err
	}
	return Tracker(0), err
}

func (a *asyncTracker) Set(result Tracker, err error) MutableTrackerPromise {
	a.src.Set(result, err)
	return a
}
