package stream

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTrackerPromise(t *testing.T) {
	tracker := Tracker(2<<32 + 1)
	expected := errors.New("expected")
	s := NewSyncTrackerPromise(tracker, expected)
	assert.False(t, s.WouldBlock())
	result, err := s.Get()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)
	result, err = s.Result()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)

	a := NewTrackerPromise()
	assert.True(t, a.WouldBlock())
	assert.Equal(t, a, a.Set(tracker, expected))
	assert.NotPanics(t, func() {
		a.Set(Tracker(0), expected)
		a.Set(Tracker(1), nil)
	})
	assert.False(t, a.WouldBlock())
	result, err = a.Get()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)
	result, err = a.Result()
	assert.Equal(t, tracker, result)
	assert.Equal(t, expected, err)

	// make sure we're safe for bad cast
	a2 := NewTrackerPromise().(*asyncTracker)
	a2.src.Set(false, nil)
	result, err = a2.Result()
	assert.Equal(t, Tracker(0), result)
	assert.Equal(t, nil, err)
}
