package ticket

import (
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
)

type compositeRedeemer struct {
	sources SourceMap
}

type SourceMap map[stream.AuthMethod]Redeemer

func NewCompositeRedeemer(src SourceMap) Redeemer {
	return &compositeRedeemer{src}
}

func (c *compositeRedeemer) Redeem(method stream.AuthMethod, code OpaqueBytes) stream.CredentialsPromise {
	if redeemer, ok := c.sources[method]; ok {
		return redeemer.Redeem(method, code)
	}
	return stream.NewSyncCredentialsPromise(stream.NoPermissions(), protocol.ErrInvalidAuthMethod)
}
