package ticket

import (
	"testing"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/stream/protocol"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestMultisourceRedeemer(t *testing.T) {
	expected, err := GetNilRedeemer().Redeem(stream.Reservation, OpaqueBytes("ticket")).Result()
	require.NoError(t, err)

	redeemer := NewCompositeRedeemer(SourceMap{stream.Reservation: GetNilRedeemer()})
	creds, err := redeemer.Redeem(stream.Reservation, OpaqueBytes("ticket")).Result()
	assert.Equal(t, creds, expected)
	assert.NoError(t, err)

	// note: this would normally be accepted by nil redeemer, but isn't mapped
	creds, err = redeemer.Redeem(stream.Validation, OpaqueBytes("token")).Result()
	assert.Equal(t, creds, stream.NoPermissions())
	assert.Equal(t, protocol.ErrInvalidAuthMethod, err)
}
