package counting

import (
	"strconv"
	"sync/atomic"

	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/ticket"
)

type factory struct {
	count uint64
}

func NewFactory() ticket.Factory { return &factory{} }
func (f *factory) Next() (stream.OpaqueBytes, error) {
	return stream.OpaqueBytes(strconv.FormatUint(atomic.AddUint64(&f.count, 1), 16)), nil
}
func (f *factory) Validate(ticket stream.OpaqueBytes) error {
	_, err := strconv.ParseUint(string(ticket), 16, 64)
	return err
}
