package jwt

import (
	"strconv"
	"sync/atomic"
	"time"

	"code.justin.tv/common/jwt"
	"code.justin.tv/devhub/e2ml/libs/stream"
	"code.justin.tv/devhub/e2ml/libs/ticket"
)

type factory struct {
	algorithm jwt.Algorithm
	header    jwt.Header
	count     uint64
}

type claims struct {
	Subject string `json:"sub"`
	IAT     int64  `json:"iat"`
}

func NewHS512Factory(secret []byte) ticket.Factory {
	return NewFactory(jwt.HS512(secret))
}

func NewFactory(a jwt.Algorithm) ticket.Factory {
	return &factory{algorithm: a, header: jwt.NewHeader(a)}
}

func (f *factory) Next() (stream.OpaqueBytes, error) {
	payload := &claims{
		Subject: strconv.FormatUint(atomic.AddUint64(&f.count, 1), 16),
		IAT:     time.Now().Unix(),
	}
	bytes, err := jwt.Encode(f.header, payload, f.algorithm)
	if err != nil {
		return nil, err
	}
	return stream.OpaqueBytes(bytes), nil
}
func (f *factory) Validate(ticket stream.OpaqueBytes) error {
	var header jwt.Header
	var claims struct{} // don't actually care
	return jwt.DecodeAndValidate(&header, &claims, f.algorithm, ticket)
}
