package jwt

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

type dummyAlg struct{}

func (dummyAlg) Name() string { return "broken" }
func (dummyAlg) Size() int    { return 1 }
func (dummyAlg) Sign(value []byte) (signature []byte, err error) {
	err = errors.New("expected")
	return
}
func (dummyAlg) Validate(value, signature []byte) error {
	return errors.New("expected")
}

func TestFactory(t *testing.T) {
	t.Run("should be able to validate its own tokens", func(t *testing.T) {
		f := NewHS512Factory([]byte("sekret"))
		ticket, err := f.Next()
		assert.NoError(t, err)
		assert.NoError(t, f.Validate(ticket))
	})

	t.Run("should forward token generation errors", func(t *testing.T) {
		f := NewFactory(dummyAlg{})
		ticket, err := f.Next()
		assert.EqualError(t, err, "expected")
		assert.Empty(t, ticket)
	})

	t.Run("should reject tokens from another factory", func(t *testing.T) {
		f := NewHS512Factory([]byte("sekret"))
		ticket, err := NewHS512Factory([]byte("other")).Next()
		assert.NoError(t, err)
		assert.EqualError(t, f.Validate(ticket), "jwt: invalid signature")
	})
}
