package websocket

import (
	"crypto/tls"
	"time"

	"code.justin.tv/devhub/lib-lifecycle/src/lifecycle"
	"code.justin.tv/devhub/e2ml/libs/errors"
	"code.justin.tv/devhub/e2ml/libs/logging"
	"code.justin.tv/devhub/e2ml/libs/timeout"
)

const defaultDuration = 10 * time.Second

type TimeoutBehavior int32

const (
	Ping       TimeoutBehavior = 0
	Disconnect TimeoutBehavior = 1
)

type Settings struct {
	Certs            *tls.Config
	Logger           logging.Function
	Lifecycle        lifecycle.Manager
	Timeout          timeout.Sampler
	OnTimeout        TimeoutBehavior
	ErrorMap         errors.Dictionary
	MaxMessageLength int
	HealthCheck      *string
}
