#!/bin/sh

# Get the private IP address of a Fargate instance into the arguments
# of the executable; this allows the discovery service to point incoming connections
# directly to this instance of the service. The IP address is not available from CDK.
host_ip=`cat /etc/hosts | tail -1 | awk {'print $1'}`

# Get task_arn from ECS metadata:
#  * Get metadata: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-metadata.html
#  * tr: substitute commas for breaklines, so grep and awk can work per line.
#  * Grep the line with the "TaskARN" key, and use aws command to split the line on double-quotes and take the 4th value.
task_arn=`wget -qO- ${ECS_CONTAINER_METADATA_URI}/task | tr ',' '\n' | grep -m1 "TaskARN" | awk -F "\"" '{print $4}'`

exec ./source --host-name=ws://$host_ip:3003 --metrics-task-arn=$task_arn --metrics-host=$host_ip:8125
