package source

import "code.justin.tv/devhub/e2ml/libs/stream"

const (
	isInactive = 0
	hasReaders = 1
	hasWriters = 2
)

type historyEntry struct {
	inner  stream.History
	active int32
}

func newHistoryEntry(inner stream.History) *historyEntry {
	return &historyEntry{inner: inner}
}

func (h *historyEntry) Key() stream.AddressKey { return h.inner.Address().Key() }
func (h *historyEntry) History() stream.History {
	if h == nil {
		return nil
	}
	return h.inner
}

func (h *historyEntry) IsActive() bool { return h.active != isInactive }
func (h *historyEntry) OnJoined()      { h.active |= hasReaders }
func (h *historyEntry) OnParted() bool {
	h.active &= ^hasReaders
	return h.IsActive()
}

func (h *historyEntry) OnRequested() { h.active |= hasWriters }
func (h *historyEntry) OnReleased() bool {
	h.active &= ^hasWriters
	return h.IsActive()
}
