package threshold

import (
	"crypto/tls"
	"net"
	"net/http"
	"net/url"
	"time"

	"code.justin.tv/devhub/e2ml/libs/discovery"
	httpbroker "code.justin.tv/devhub/e2ml/libs/discovery/broker/http"
	"code.justin.tv/devhub/e2ml/libs/logging"
)

func NewHTTPBroker(url *url.URL, tls *tls.Config, logger logging.Function) discovery.Broker {
	cli := http.Client{
		Transport: &http.Transport{
			TLSClientConfig: tls,
			DialContext: (&net.Dialer{
				Timeout:   30 * time.Second,
				KeepAlive: 30 * time.Second,
				DualStack: true,
			}).DialContext,
			MaxIdleConns:        30,
			MaxIdleConnsPerHost: 10,
			MaxConnsPerHost:     50,
		},
		Timeout: 10 * time.Second,
	}
	return httpbroker.NewBroker(url, cli, logger)
}
