package lifecycle

import (
	"os"
	"syscall"
)

// Interrupt causes any Managers that are listening for interrupts to continue
// execution; it is most useful in situations where a fatal condition should
// cause shutdown of a service.
func Interrupt() error {
	proc, err := os.FindProcess(os.Getpid())
	if err == nil {
		err = proc.Signal(syscall.SIGUSR2)
	}
	return err
}
