package lifecycle

type tickCloser struct {
	mgr  Manager
	stop chan struct{}
}

func newTickCloser(mgr Manager) *tickCloser {
	cls := &tickCloser{mgr: mgr, stop: make(chan struct{})}
	mgr.RegisterHook(cls.stop, cls.exec)
	return cls
}

func (t *tickCloser) Close() error {
	return t.mgr.ExecuteHook(t.stop)
}

func (t *tickCloser) exec() error {
	close(t.stop)
	return nil
}
