# e2topics

Experimental new architecture for the e2ml rewrite.

Loadtest dashboard: https://isengard.amazon.com/federate?account=947140302170&role=admin&destination=%2Fcloudwatch%2Fhome%3Fregion%3Dus-west-2%23dashboards%3Aname%3De2topics-loadtests


### Run locally

 * Review `config/dynamic_config/local.toml` for settings when running locally.
 * Run with `make run`.

You need to have a local Redis and DyanmoDB (only for DYNAMODB implementation). Using `make run` starts the service locally with the default configuration. Run `go run main.go -h` to see other configuration settings.

#### Running a Redis cluster locally

 * Install Redis from https://redis.io/download. Select version 5.0.6 to match the version used in AWS Elasticache.
 * If you want to run Redis in cluster mode, you need to install with download + `make`. The MacOS installation with brew does not include the `create-cluster` command.
 * Download redis whenever you want, but for this example we will use `~/Applications`. Once downloaded, cd to `~/Applications/redis-5.0.6` and run `make`. More details on quick start: https://redis.io/topics/quickstart
 * Optional: Make a symbolic link to redis-cli to somewhere avaiable in your PATH (e.g. `~/bin` or `/usr/local/bin/`) so it can be used from anywhere: `ln -s ~/Applications/redis-5.0.6/src/redis-cli ~/bin`; Maybe same for `src/redis-server`.
 * Use the script on `utils/create-cluster` to quickly start a Redis Cluster with 3 masters and 3 replicas.
   * `cd ~/Applications/redis-5.0.6/utils/create-cluster` and then
   * `./create-cluster start`.
   * If this is the first time, also do `./create-cluster create`. More details in the cluster tutorial: https://redis.io/topics/cluster-tutorial
 * Test if the cluster is up: `redis-cli -p 30001 ping`; or connect to the cluster: `redis-cli -p 30001 -c` and then type something like `GET foo`.

#### Running DynamoDB locally

The dynamic_config setting for `PubsubType` is used to run with different implementations (see `e2topics/publisher.go` for valid values). To test an implementation that uses DynamoDB, you can run DynamoDB locally.

Install and run dynamodb-local: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBLocal.DownloadingAndRunning.html. Or run as Docker container: `docker run -d -p 8000:8000 -v /tmp/data:/data/ dwmkerr/dynamodb -dbPath /data/`.

Give credentials to access the local profile: add this on your `.aws/credentials` file:
```
[local]
aws_access_key_id=fakeid
aws_secret_access_key=fakesecret
```

Create the e2topics table (using aws-cli with the arg `--endpoint-url http://localhost:8000`):
```
aws dynamodb create-table \
    --table-name e2topics \
    --attribute-definitions \
        AttributeName=id,AttributeType=S \
    --key-schema \
        AttributeName=id,KeyType=HASH \
    --provisioned-throughput \
        ReadCapacityUnits=20,WriteCapacityUnits=20 \
    --endpoint-url http://localhost:8000 --profile local
```

Check if the table was created:
```
aws dynamodb list-tables --endpoint-url http://localhost:8000 --profile local
```

### Build and Deploy

 * `make build` to build the Docker image from the current branch.
 * `make push` to deploy the Docker image to ECR as "latest", which will be used by the next test run.

### Run load tests from Fargate

 * If you have local changes, make sure to commit, build and push to ECR.
 * Review `config/dynamic_config/dev01.toml` for settings when running the dev01 test instance.
 * `make dev01_run` to start the remote test with dev01 config. (make sure to `mwinit` and get ada credentials first).
 * Go to CloudWatch on the testing account to see the result.
 * `make dev01_stop` when you are done. If you forget to stop the load test, there will be a big AWS bill next month!

