import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as cdk from '@aws-cdk/core';

interface DynamodbStackProps extends cdk.StackProps {
    tableName: string;
}

export class DynamodbStack extends cdk.Stack {
  public readonly table: dynamodb.ITable;

  constructor(scope: cdk.Construct, id: string, props: DynamodbStackProps) {
    super(scope, id, props);

    const table = new dynamodb.Table(this, 'Table', {
        tableName: props.tableName,
        partitionKey: {
            name: 'id',
            type: dynamodb.AttributeType.STRING,
        },
        billingMode: dynamodb.BillingMode.PROVISIONED,
        removalPolicy: cdk.RemovalPolicy.DESTROY,
    });
    this.table = table;

    // Autoscaling
    const writeScaling = table.autoScaleWriteCapacity({
      minCapacity: 1,
      maxCapacity: 40000,
    });
    writeScaling.scaleOnUtilization({
      targetUtilizationPercent: 70,
    });
    const readScaling = table.autoScaleReadCapacity({
      minCapacity: 1,
      maxCapacity: 40000,
    });
    readScaling.scaleOnUtilization({
      targetUtilizationPercent: 70,
    });
  }
}
