import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';

interface S3BucketStackProps extends cdk.StackProps {
    bucketName: string;
}

export class S3BucketStack extends cdk.Stack {
    public bucket: s3.IBucket;

    constructor(scope: cdk.Construct, id: string, props: S3BucketStackProps) {
        super(scope, id, props);

        this.bucket = new s3.Bucket(this, 'S3Bucket', {
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            bucketName: props.bucketName,
        });
    }
}
