package e2topics

import (
	"fmt"

	"github.com/mediocregopher/radix/v3"
)

// NOTE: Some of this code was generated by the script:
// go run ./scripts/redis_cluster_find_key_slots/main.go

const redisHashSlots = 16384 // all available Redis Cluster Hash slots

// keyGroupTags are key tags that map into a known Redis Cluster slot
var keyGroupTags = []string{
	"aG", // groups [0:127] on hash slot 56
	"aC", // groups [128:255] on hash slot 188
	"aO", // groups [256:383] on hash slot 304
	"aK", // groups [384:511] on hash slot 436
	"aV", // groups [512:639] on hash slot 552
	"aR", // groups [640:767] on hash slot 684
	"bu", // groups [768:895] on hash slot 890
	"aZ", // groups [896:1023] on hash slot 932
	"ae", // groups [1024:1151] on hash slot 1048
	"aa", // groups [1152:1279] on hash slot 1180
	"am", // groups [1280:1407] on hash slot 1296
	"ai", // groups [1408:1535] on hash slot 1428
	"3",  // groups [1536:1663] on hash slot 1584
	"7",  // groups [1664:1791] on hash slot 1716
	"bW", // groups [1792:1919] on hash slot 1882
	"ax", // groups [1920:2047] on hash slot 1924
	"D",  // groups [2048:2175] on hash slot 2112
	"c6", // groups [2176:2303] on hash slot 2284
	"L",  // groups [2304:2431] on hash slot 2376
	"H",  // groups [2432:2559] on hash slot 2508
	"U",  // groups [2560:2687] on hash slot 2640
	"Q",  // groups [2688:2815] on hash slot 2772
	"b1", // groups [2816:2943] on hash slot 2874
	"Y",  // groups [2944:3071] on hash slot 3036
	"f",  // groups [3072:3199] on hash slot 3168
	"b",  // groups [3200:3327] on hash slot 3300
	"n",  // groups [3328:3455] on hash slot 3432
	"j",  // groups [3456:3583] on hash slot 3564
	"w",  // groups [3584:3711] on hash slot 3696
	"s",  // groups [3712:3839] on hash slot 3828
	"a8", // groups [3840:3967] on hash slot 3904
	"dD", // groups [3968:4095] on hash slot 4014
	"aF", // groups [4096:4223] on hash slot 4121
	"aB", // groups [4224:4351] on hash slot 4253
	"aN", // groups [4352:4479] on hash slot 4369
	"aJ", // groups [4480:4607] on hash slot 4501
	"aW", // groups [4608:4735] on hash slot 4617
	"aS", // groups [4736:4863] on hash slot 4749
	"bt", // groups [4864:4991] on hash slot 4955
	"bp", // groups [4992:5119] on hash slot 5087
	"ad", // groups [5120:5247] on hash slot 5177
	"bK", // groups [5248:5375] on hash slot 5351
	"al", // groups [5376:5503] on hash slot 5425
	"ah", // groups [5504:5631] on hash slot 5557
	"2",  // groups [5632:5759] on hash slot 5649
	"6",  // groups [5760:5887] on hash slot 5781
	"bV", // groups [5888:6015] on hash slot 6011
	"ay", // groups [6016:6143] on hash slot 6053
	"E",  // groups [6144:6271] on hash slot 6241
	"A",  // groups [6272:6399] on hash slot 6373
	"M",  // groups [6400:6527] on hash slot 6505
	"I",  // groups [6528:6655] on hash slot 6637
	"T",  // groups [6656:6783] on hash slot 6769
	"P",  // groups [6784:6911] on hash slot 6901
	"b0", // groups [6912:7039] on hash slot 6939
	"X",  // groups [7040:7167] on hash slot 7165
	"g",  // groups [7168:7295] on hash slot 7233
	"c",  // groups [7296:7423] on hash slot 7365
	"o",  // groups [7424:7551] on hash slot 7497
	"k",  // groups [7552:7679] on hash slot 7629
	"v",  // groups [7680:7807] on hash slot 7761
	"r",  // groups [7808:7935] on hash slot 7893
	"a9", // groups [7936:8063] on hash slot 8033
	"z",  // groups [8064:8191] on hash slot 8157
	"aE", // groups [8192:8319] on hash slot 8314
	"aA", // groups [8320:8447] on hash slot 8446
	"aM", // groups [8448:8575] on hash slot 8562
	"aI", // groups [8576:8703] on hash slot 8694
	"aT", // groups [8704:8831] on hash slot 8810
	"aP", // groups [8832:8959] on hash slot 8942
	"bw", // groups [8960:9087] on hash slot 9016
	"aX", // groups [9088:9215] on hash slot 9190
	"ag", // groups [9216:9343] on hash slot 9306
	"ac", // groups [9344:9471] on hash slot 9438
	"ao", // groups [9472:9599] on hash slot 9554
	"ak", // groups [9600:9727] on hash slot 9686
	"1",  // groups [9728:9855] on hash slot 9842
	"5",  // groups [9856:9983] on hash slot 9974
	"9",  // groups [9984:10111] on hash slot 10106
	"az", // groups [10112:10239] on hash slot 10182
	"F",  // groups [10240:10367] on hash slot 10242
	"B",  // groups [10368:10495] on hash slot 10374
	"N",  // groups [10496:10623] on hash slot 10506
	"J",  // groups [10624:10751] on hash slot 10638
	"W",  // groups [10752:10879] on hash slot 10770
	"S",  // groups [10880:11007] on hash slot 10902
	"b3", // groups [11008:11135] on hash slot 11128
	"b7", // groups [11136:11263] on hash slot 11260
	"d",  // groups [11264:11391] on hash slot 11298
	"eE", // groups [11392:11519] on hash slot 11454
	"l",  // groups [11520:11647] on hash slot 11562
	"h",  // groups [11648:11775] on hash slot 11694
	"u",  // groups [11776:11903] on hash slot 11826
	"q",  // groups [11904:12031] on hash slot 11958
	"dB", // groups [12032:12159] on hash slot 12136
	"y",  // groups [12160:12287] on hash slot 12222
	"aD", // groups [12288:12415] on hash slot 12379
	"bk", // groups [12416:12543] on hash slot 12421
	"aL", // groups [12544:12671] on hash slot 12627
	"aH", // groups [12672:12799] on hash slot 12759
	"aU", // groups [12800:12927] on hash slot 12875
	"aQ", // groups [12928:13055] on hash slot 13007
	"bv", // groups [13056:13183] on hash slot 13081
	"aY", // groups [13184:13311] on hash slot 13255
	"af", // groups [13312:13439] on hash slot 13435
	"ab", // groups [13440:13567] on hash slot 13567
	"an", // groups [13568:13695] on hash slot 13683
	"aj", // groups [13696:13823] on hash slot 13815
	"0",  // groups [13824:13951] on hash slot 13907
	"4",  // groups [13952:14079] on hash slot 14039
	"8",  // groups [14080:14207] on hash slot 14171
	"bP", // groups [14208:14335] on hash slot 14269
	"G",  // groups [14336:14463] on hash slot 14371
	"C",  // groups [14464:14591] on hash slot 14503
	"O",  // groups [14592:14719] on hash slot 14635
	"K",  // groups [14720:14847] on hash slot 14767
	"V",  // groups [14848:14975] on hash slot 14899
	"R",  // groups [14976:15103] on hash slot 15031
	"b2", // groups [15104:15231] on hash slot 15193
	"Z",  // groups [15232:15359] on hash slot 15295
	"e",  // groups [15360:15487] on hash slot 15363
	"a",  // groups [15488:15615] on hash slot 15495
	"m",  // groups [15616:15743] on hash slot 15627
	"i",  // groups [15744:15871] on hash slot 15759
	"t",  // groups [15872:15999] on hash slot 15891
	"p",  // groups [16000:16127] on hash slot 16023
	"dC", // groups [16128:16255] on hash slot 16201
	"x",  // groups [16256:16383] on hash slot 16287
}

var keyGroupSize = redisHashSlots / len(keyGroupTags) // number of slots for each keyGroupTag

// keyGroupIdx returns the index such as keyGroupTags[keyGroupIdx] is the keyGroupTag for this key
func keyGroupIdx(key []byte) int {
	hashSlot := int(radix.CRC16(key)) % redisHashSlots // same Cluster HASH SLOT that Redis would calculate.
	return hashSlot / keyGroupSize
}

func taggedGroupKey(groupTag, key string) string {
	return fmt.Sprintf("{%s}%s", groupTag, key)
}
