package e2topics

import (
	"github.com/mediocregopher/radix/v3/trace"
	"github.com/rs/zerolog/log"
)

func NewRedisPoolMetrics(stats Statter) trace.PoolTrace {
	return trace.PoolTrace{
		InitCompleted: func(e trace.PoolInitCompleted) {
			log.Info().Int("RedisPool.AvailCount", e.AvailCount).Dur("dur", e.ElapsedTime).Msg("RedisPool init complete")
		},
		ConnCreated: func(e trace.PoolConnCreated) {
			if e.Err != nil {
				stats.Inc("RedisPool.CreatedErr", 1)
				log.Error().Err(e.Err).Dur("dur", e.ConnectTime).Msgf("RedisPool failed to add NEW connection")
			} else {
				stats.Inc("RedisPool.CreatedOk", 1)
				if e.Reason == trace.PoolConnCreatedReasonRefill {
					stats.Inc("RedisPool.CreatedOk.Refill", 1)
				}
				if e.Reason == trace.PoolConnCreatedReasonPoolEmpty {
					stats.Inc("RedisPool.CreatedOk.PoolEmpty", 1)
				}
			}
		},
		ConnClosed: func(e trace.PoolConnClosed) {
			stats.Inc("RedisPool.Closed", 1)
			if e.Reason == trace.PoolConnClosedReasonBufferDrain {
				stats.Inc("RedisPool.Closed.BufferDrained", 1)
			}
			if e.Reason == trace.PoolConnClosedReasonPoolFull {
				stats.Inc("RedisPool.Closed.PoolFull", 1)
			}

			stats.Gauge("RedisPool.AvailCount", e.AvailCount) // best metric is Average
		},
		DoCompleted: func(e trace.PoolDoCompleted) {
			stats.Duration("Redis.ElapsedTime", e.ElapsedTime)
			stats.Gauge("RedisPool.AvailCount", e.AvailCount) // best metric is Average
		},
	}
}
