@IF "%~1" == "" ECHO OFF
SETLOCAL

REM Ensure DotNetLib and DotNetLibTest have dependencies.
CD /D "%~dp0"
IF NOT EXIST packages (
	ECHO You must open the solution in Visual Studio 2017 and restore the NuGet packages.
	IF ERRORLEVEL 1 EXIT /B
)
MSBuild /nologo /target:restore

REM Add Visual Studio environment variables.
CALL "%~dp0UseVisualStudioTools.cmd"
IF ERRORLEVEL 1 EXIT /B

REM Ensure TypeScriptLib has dependencies.
IF NOT EXIST TypeScriptLib\node_modules (
	CD TypeScriptLib
	CALL yarn
	IF ERRORLEVEL 1 EXIT /B
	CD ..
)

REM Build all configurations for all platforms.
FOR %%I IN ("Any CPU" Gaming.Xbox.XboxOne.x64 NX64 ORBIS x64 x86) DO (
	FOR %%J IN (Debug Release) DO (
		MSBuild /nologo /p:Platform=%%I /p:Configuration=%%J /m enhanced-experiences-sdk.sln
		IF ERRORLEVEL 1 EXIT /B
	)
)

REM Build the Python library for packaging.
CD /D "%~dp0\PythonLib"
python setup.py sdist

REM Build the TypeScript library for packaging.
CD /D "%~dp0\TypeScriptLib"
yarn build
