﻿using System;
using System.Threading;

namespace Twitch.EnhancedExperiences
{
    internal class Cancelation : IDisposable
    {
        internal CancellationToken Value => source.Token;
        private readonly CancellationTokenSource source;

        public void Dispose() => source.Dispose();

        internal Cancelation() => source = new CancellationTokenSource();

        internal Cancelation(TimeSpan timeout) => source = new CancellationTokenSource(timeout);

        internal void Cancel() => source.Cancel();

        internal CancellationTokenRegistration Register(Action action) => Value.Register(action);
    }
}
