﻿using System;
using System.Collections.Generic;
using System.Linq;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Twitch.EnhancedExperiences
{
    internal class DeltaOperation
    {
        internal string Path;
        internal DeltaOperationType Type;
        internal object Value;
        private const int maximumDeltaMessageSize = 20000;

        internal bool IsDeltaTooLarge()
        {
            var deltaMessage = new JObject { new JProperty("delta", new[] { AsArray() }) };
            return IsDeltaTooLarge(deltaMessage);
        }

        internal static bool IsDeltaTooLarge(IEnumerable<DeltaOperation> deltaOperations)
        {
            var deltaMessage = MakeDeltaMessage(deltaOperations);
            return IsDeltaTooLarge(deltaMessage);
        }

        internal static bool IsDeltaTooLarge(JObject deltaMessage)
        {
            return deltaMessage.ToString(Formatting.None).Length > maximumDeltaMessageSize;
        }

        internal static JObject MakeDeltaMessage(IEnumerable<DeltaOperation> deltaOperations)
        {
            var deltaMessage = new JObject { new JProperty("delta", deltaOperations.Select((e) => e.AsArray())) };
            return deltaMessage;
        }

        private JArray AsArray()
        {
            switch (Type)
            {
            case DeltaOperationType.Append:
                return new JArray(Path, "a", new JArray(Value));
            case DeltaOperationType.Remove:
                return new JArray(Path);
            case DeltaOperationType.Update:
                return new JArray(Path, Value);
            default:
                throw new Exception($"unexpected delta operation type \"{Type}\"");
            }
        }
    }

    internal enum DeltaOperationType { Append, Remove, Update }
}
