﻿using System;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Twitch.EnhancedExperiences;

namespace DotNetLibTest
{
    [TestClass]
    public class DataSourceTest
    {
        internal static readonly int SendDelay = 110;

        [AssemblyInitialize]
        public static void SetSendDelayAndUrl(TestContext testContext)
        {
#if DEBUG
            Connection.sendDelay = TimeSpan.FromMilliseconds(SendDelay);
            Connection.url = new Uri("ws://localhost:6006");
#endif
        }

        internal static DataSource.Configuration MakeConfiguration(string token = null)
        {
            var configuration = new DataSource.Configuration
            {
                GameId = "516575",
                InitialData = new object(),
                IsDebugging = true,
                Token = token,
            };
            return configuration;
        }

        internal static async Task<DataSource> CreateAndConnectAsync(object data = null)
        {
            var dataSource = new DataSource();
            var configuration = MakeConfiguration("token");
            if (data != null)
            {
                configuration.InitialData = data;
            }
            await dataSource.ConnectAsync(configuration);
            return dataSource;
        }
    }
}
