// Poly-fill the String trim method.
if (!String.prototype.trim) {
  String.prototype.trim = function() {
    return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
  };
}

// Poly-fill the String startsWith method.
if (!String.prototype.startsWith) {
  String.prototype.startsWith = function(search, rawPos) {
    var pos = rawPos > 0 ? rawPos | 0 : 0;
    return this.substring(pos, pos + search.length) === search;
  };
}

// Create the file system object.
var ForReading = 1, ForWriting = 2, ForAppending = 8;
var fso = WScript.CreateObject('Scripting.FileSystemObject');

// Extract command line parameters.
var level = WScript.Arguments(0);

// Select the index for the level.
var indices = { 'major': 0, 'minor': 1, 'patch': 2 };
var index = indices[level];
if (typeof index === 'undefined') {
  WScript.Echo('Unknown level "' + level + '"');
  WScript.Quit(1);
}

// Increment the version in the C++ version file.
var filePath = getFullPath('version.txt');
inputFile = fso.OpenTextFile(filePath, ForReading);
line = inputFile.ReadLine();
inputFile.Close();
outputFile = fso.CreateTextFile(filePath);
var newVersion = incrementVersion(line);
outputFile.WriteLine(newVersion);
outputFile.Close();

// Increment the version in the Python setup file.
filePath = getFullPath('PythonLib\\setup.py');
updateFileVersion(filePath, { start: 'version=', separator: "'", index: 1 });

// Increment the version in the TypeScript package file.
filePath = getFullPath('TypeScriptLib\\package.json');
updateFileVersion(filePath, { start: '"version":', separator: '"', index: 3 });

function getFullPath(fileName) {
  var parts = WScript.ScriptFullName.split('\\');
  parts.pop();
  parts.push(fileName);
  var filePath = parts.join('\\');
  return filePath;
}

function incrementVersion(currentVersion) {
  var parts = currentVersion.split('.');
  for (var i = 0, n = parts.length; i < n; ++i) {
    var part = parts[i];
    parts[i] = i < index ? part : i === index ? Number(part) + 1 : '0';
  }
  var newVersion = parts.join('.');
  return newVersion;
}

function updateFileVersion(filePath, x) {
  var inputFile = fso.OpenTextFile(filePath, ForReading);
  var found, lines = [];
  while (!inputFile.AtEndOfStream) {
    var line = inputFile.ReadLine();
    if (line.trim().startsWith(x.start)) {
      // Increment the desired version part, setting subsequent parts to zero.
      var parts = line.split(x.separator || '\n');
      parts[x.index] = newVersion;
      line = parts.join(x.separator);
      found = true;
    }
    lines.push(line);
  }
  inputFile.Close();
  if (!found) {
    WScript.Echo('version not found in', filePath);
    WScript.Quit(1);
  }
  var outputFile = fso.CreateTextFile(filePath);
  for (var i = 0, n = lines.length; i < n; ++i) {
    outputFile.WriteLine(lines[i]);
  }
  outputFile.Close();
}
