@IF "%~1" == "" ECHO OFF
SETLOCAL

REM Ensure there is a Base SDK to include.
SET BASE_SDK=%~dp0..\base-sdk\packages\BaseSDK
IF NOT EXIST "%BASE_SDK%" (
	ECHO "%BASE_SDK%" not found
	EXIT /B 1
)

REM Validate the command line and set the environment variables.
IF NOT "%~2" == "" EXIT /B 2
SET ZIP=%SYSTEMDRIVE%\Program Files\7-Zip\7z.exe
IF NOT EXIST "%ZIP%" (
	ECHO "%ZIP%" not found
	EXIT /B 1
)
SET NAME=EnhancedExperiencesSDK
SET ROOT=%~dp0packages
SET SDK=%ROOT%\%NAME%
FOR /F "delims=' tokens=2" %%I IN ('TYPE "%~dp0PythonLib\setup.py" ^| find "version"') DO SET PYTHON_VERSION=%%I
FOR /F "delims=" %%I IN ('TYPE "%~dp0version.txt"') DO SET VERSION=%%I
SET ZIP_FILE_PATH=%SDK%-%VERSION%.zip

REM Create the package directories.
FOR %%I IN ("%ROOT%\BaseSDK" "%SDK%") DO (
	IF EXIST %%I (
		RD /Q /S %%I
		IF ERRORLEVEL 1 EXIT /B
	)
)
FOR %%I IN (DotNet Gaming.Xbox.XboxOne.x64 NX64 ORBIS x64 x86) DO FOR %%J IN (Debug Release) DO MD "%SDK%\%%I\%%J"
IF ERRORLEVEL 1 EXIT /B
MD "%SDK%\TypeScript"
IF ERRORLEVEL 1 EXIT /B

REM Copy the Base SDK.
XCOPY /I /S /Y "%BASE_SDK%" "%ROOT%\BaseSDK"
IF ERRORLEVEL 1 EXIT /B

REM Copy the platform-agnostic files.
COPY "%~dp0Shared\Twitch.h" "%SDK%\%NAME%.h"
COPY "%~dp0LICENSE" "%SDK%"
IF ERRORLEVEL 1 EXIT /B

REM Copy the Python files to their output directory.
SET P=packages\enhanced-experiences-sdk-%PYTHON_VERSION%
"%ZIP%" x -y "%~dp0PythonLib\dist\enhanced-experiences-sdk-%PYTHON_VERSION%.tar.gz" -opackages
IF ERRORLEVEL 1 EXIT /B
IF EXIST %P% RD /Q /S %P%
"%ZIP%" x "%~dp0packages\dist\enhanced-experiences-sdk-%PYTHON_VERSION%.tar" -opackages
IF ERRORLEVEL 1 EXIT /B
MOVE %P% "%SDK%\Python"
IF ERRORLEVEL 1 EXIT /B

REM Copy the TypeScript files to their output directory.
COPY "%~dp0TypeScriptLib\dist\*" "%SDK%\TypeScript"
IF ERRORLEVEL 1 EXIT /B
DEL "%SDK%\TypeScript\*.map"
IF ERRORLEVEL 1 EXIT /B

REM Copy all output files to their respective package directories.
FOR %%I IN (Debug Release) DO (
	FOR %%J IN (deps.json dll pdb) DO (
		COPY "%~dp0DotNetLib\bin\%%I\netstandard2.0\Twitch.EnhancedExperiences.%%J" "%SDK%\DotNet\%%I"
	)
	COPY "%~dp0Gaming.Xbox.XboxOne.x64\%%I\%NAME%.lib" "%SDK%\Gaming.Xbox.XboxOne.x64\%%I"
	COPY "%~dp0Gaming.Xbox.XboxOne.x64\%%I\%NAME%.pdb" "%SDK%\Gaming.Xbox.XboxOne.x64\%%I"
	COPY "%~dp0NX64\%%I\lib%NAME%.a" "%SDK%\NX64\%%I"
	COPY "%~dp0ORBIS\%%I\lib%NAME%.a" "%SDK%\ORBIS\%%I"
	FOR %%J IN (x64 x86) DO (
		COPY "%~dp0%%J\%%I\%NAME%.lib" "%SDK%\%%J\%%I"
		COPY "%~dp0%%J\%%I\%NAME%.pdb" "%SDK%\%%J\%%I"
	)
)
IF ERRORLEVEL 1 EXIT /B

REM Create the Zip file.
IF EXIST "%ZIP_FILE_PATH%" DEL /F /Q "%ZIP_FILE_PATH%"
IF ERRORLEVEL 1 EXIT /B
"%ZIP%" a -r "%ZIP_FILE_PATH%" "%ROOT%\BaseSDK" "%SDK%"
IF ERRORLEVEL 1 EXIT /B
COPY /Y "%ZIP_FILE_PATH%" "%SDK%.zip"
IF ERRORLEVEL 1 EXIT /B
