@ECHO OFF
SETLOCAL

REM Validate the arguments.
IF "%~1" == "" EXIT /B 2
IF NOT "%~3" == "" EXIT /B 2

REM Configure the environment variables and the temporary file.
CALL "%~dp0UseVisualStudioTools.cmd"
IF ERRORLEVEL 1 EXIT /B
SET SOURCE_FILE_PATH="%~dp0version.txt"
SET LANGUAGE=%1
SET TARGET_FILE_PATH=%2

REM Create or update the version file, if necessary.
cscript //nologo "%~dpn0.js" %LANGUAGE% %SOURCE_FILE_PATH% %T%
IF EXIST %TARGET_FILE_PATH% (
	FC %T% %TARGET_FILE_PATH% > nul
	IF ERRORLEVEL 1 (
		ECHO Updating version file
		MOVE /Y %T% %TARGET_FILE_PATH%
	) ELSE (
		ECHO No change to version file
		DEL %T%
	)
) ELSE (
	ECHO Creating version file
	MOVE /Y %T% %TARGET_FILE_PATH%
)

REM Create or update the WebSocket URL file, if necessary.
SET F="%~dp0ws_url.inl"
FOR /F "tokens=14" %%I IN ('ipconfig ^| find "IPv4"') DO SET IP=%%I
ECHO constexpr string_t url = _T("ws://%IP%:6006");> %T%
IF EXIST %F% (
	FC %T% %F% > nul
	IF ERRORLEVEL 1 (
		ECHO Updating WebSocket URL file
		MOVE /Y %T% %F%
	) ELSE (
		ECHO No change to WebSocket URL file
		DEL %T%
	)
) ELSE (
	ECHO Creating WebSocket URL file
	MOVE /Y %T% %F%
)
