# Twitch Enhanced Experiences SDK

This is the Twitch Enhanced Experiences SDK (E2 SDK) in C++ targeting Windows
Desktop, PlayStation 4, and Xbox One and TypeScript targeting Node.

The development environment is Windows.  Due to technical limitations with
Twitch's security environment, you must first follow the instructions given
[here](https://wiki.twitch.com/display/SEC/Windows+Setup) and use Git Bash for
any Git commands that communicate with Twitch's GitHub Enterprise installation.

Execute the following command in Git Bash to clone this repository since it
contains Git sub-modules.
```
git clone --recurse-submodules git@git.xarth.tv:devhub/enhanced-experiences-sdk.git
```
If you cloned it without the `--recurse-submodules` flag, execute the following
command in Git Bash in the repository directory to populate the sub-modules.
```
git submodule update --init --recursive
```

## Set Up

1. Install **Visual Studio 2017** with C++, Node, and Python support.
1. Install [yarn](https://yarnpkg.com/lang/en/docs/install/).
1. Add the following to your `.gitconfig` file in your home directory.

```
[core]
	symlinks = true
[url "git@git.xarth.tv:"]
	insteadOf = https://git.xarth.tv/
```
1. Create a `.pypirc` file in your home directory containing the following.  See [Using Artifactory](https://git.xarth.tv/dta/docs/blob/master/artifactory/using-artifactory.md) for how to generate a password.  Note that the repository is not https://pkgs.xarth.tv.
```
[distutils]
index-servers = local
[local]
repository: https://packages.internal.justin.tv/artifactory/api/pypi/ip-pypi
username: your-artifactory-user-name
password: artifactory-generated-password
```
1. Open Git Bash.
1. Change the current directory to `TypeScriptLib` by running `cd .../enhanced-experiences-sdk/TypeScriptLib`.
1. Create the `node_modules` directory by running `yarn`.
1. Change the current directory to `DataSourceTest` by running `cd ../DataSourceTest`.
1. Create the `node_modules` directory by running `npm i`.
1. Open a command prompt.
1. Change the current directory to `PythonLib` by running `CD ...\enhanced-experiences-sdk\PythonLib`.
1. Ensure Python is in your path.  The Visual Studio installer puts it in `%SystemDrive%\Program Files (x86)\Microsoft Visual Studio\Shared\Python36_64`.
1. Create the Python virtual environment by running `python -m venv venv`.
1. Run `venv\Scripts\activate` to activate the Python virtual environment.
1. Update `pip` by running `python -m pip install --upgrade pip`.
1. Update `setuptools` by running `pip install -U setuptools`.
1. Install the `wheel` package by running `pip install wheel`.
1. Install the required packages by running `pip install -r requirements.txt`.

## Release

You must have the following in your `~/.pip/pip.conf` file.  The path is `%USERPROFILE%\pip\pip.ini` on Windows.  Note that the URL is not https://pkgs.xarth.tv.
```
[global]
index-url = https://packages.internal.justin.tv/artifactory/api/pypi/vr-pypi/simple
```
This configuration requires you use either the WPA2 office network or the Amazon or Twitch VPN to access [Artifactory](https://pkgs.xarth.tv/artifactory/webapp/#/home).

For simplicity, you may have `~/.pip/pip.conf` (`%USERPROFILE%\pip\pip.ini` on
Windows) and `~/.pypirc` (`%USERPROFILE%\.pypirc` on Windows) have the same
content, a combination of the `distutils`, `global`, and `local` sections above.

### From a Command Prompt

1. Change the current directory to the project root by running `CD ...\enhanced-experiences-sdk`.
2. If necessary, increment the version patch by running `IncrementVersion.cmd`.  If you want to increment the major or minor part of the version, provide `major` or `minor` as a command line argument.
3. Build all configurations by running `BuildAllConfigurations.cmd`.
4. Package all configurations by running `Package.cmd`.
5. Publish the NPM package by running `Publish.cmd`.

### From Windows Explorer

1. Navigate to the project root.
2. If necessary, increment the version patch by double-clicking `IncrementVersion.cmd`.  If you want to increment the major or minor part of the version, use the Command Prompt instructions above.
3. Build all configurations by double-clicking `BuildAllConfigurations.cmd`.
4. Package all configurations by double-clicking `Package.cmd`.
5. Publish the NPM package by double-clicking `Publish.cmd`.
