#pragma once

#if defined(_XBOX_ONE)
# include <winsdkver.h>
# define _WIN32_WINNT 0x0A00
# include <sdkddkver.h>

// Use the C++ standard templated min/max
# define NOMINMAX

// DirectX apps don't need GDI
# define NODRAWTEXT
# define NOGDI
# define NOBITMAP

// Include <mcx.h> if you need this
# define NOMCX

// Include <winsvc.h> if you need this
# define NOSERVICE

// WinHelp is deprecated
# define NOHELP

# define _CRT_RAND_S
# include <Windows.h>
# include <XGameRuntime.h>
# include <WinSock2.h>
# include <winhttp.h>
# include <tchar.h>

# define ERROR_INVALID_RESPONSE ERROR_WINHTTP_INVALID_SERVER_RESPONSE
# define FromPlatformError HRESULT_FROM_WIN32
#elif defined(_WIN32)
# define NOMINMAX
# include "targetver.h"

# define _CRT_RAND_S
# define WIN32_LEAN_AND_MEAN

// Windows header files
# include <windows.h>
# include <WinSock2.h>
# include <WS2tcpip.h>
# if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#  include <winhttp.h>
#  define ERROR_INVALID_RESPONSE ERROR_WINHTTP_INVALID_SERVER_RESPONSE
#  undef ERROR_CONNECTION_ABORTED
#  define ERROR_CONNECTION_ABORTED ERROR_WINHTTP_CONNECTION_ERROR
# else
#  define ERROR_INVALID_RESPONSE 12152
# endif
# define ERROR_CANCELED ERROR_CANCELLED
# include <tchar.h>
# define FromPlatformError HRESULT_FROM_WIN32
#elif defined(__ORBIS__)
// PS4 header files
# include <kernel.h>
# include <libsysmodule.h>
# include <libnet/errno.h>
# include <net.h>
# include <iostream>

# define _countof(a) (sizeof(a) / sizeof((a)[0]))
# define __fallthrough ((void)0)
# define _T(s) s
# define _istalnum isalnum
# define _stprintf_s sprintf_s
# define _stscanf_s sscanf_s
# define _tcschr strchr
# define _tcscmp std::strcmp
# define _totlower tolower
# define UNREFERENCED_PARAMETER(p) ((void)(p))

using SOCKET = SceNetId;
using TCHAR = char;
using LPTSTR = TCHAR*;
using LPCTSTR = TCHAR const*;

// Missing error code macros
# define ERROR_SUCCESS 0
# define ERROR_ACCESS_DENIED EACCES
# define ERROR_BAD_ARGUMENTS EINVAL
# define ERROR_CANCELED ECANCELED
# define ERROR_CONNECTION_ABORTED ECONNABORTED
# define ERROR_INVALID_OPERATION EOPNOTSUPP
# define ERROR_INVALID_RESPONSE EBADMSG
# define ERROR_INVALID_STATE EDOOFUS
# define ERROR_TIMEOUT ETIMEDOUT

# define FromPlatformError(error) static_cast<int>(SCE_ERROR_MAKE_ERROR(0, (error)))

inline unsigned GetTickCount() {
	auto time = sceKernelGetProcessTime();
	return static_cast<unsigned>(time / 1'000);
}
#elif defined(__NX__)
# include <nn/os.h>

// Missing error code macros
# define ERROR_BAD_ARGUMENTS EINVAL
# define ERROR_INVALID_STATE EDOM

# define _countof(a) (sizeof(a) / sizeof((a)[0]))
# define __fallthrough ((void)0)
# define _T(s) s
# define _istalnum isalnum
# define _tcschr strchr
# define _totlower tolower
# define FromPlatformError(error) static_cast<int>(0x80000000 | (error))
# define UNREFERENCED_PARAMETER(p) ((void)(p))

using SOCKET = int;
using TCHAR = char;
using LPTSTR = TCHAR*;
using LPCTSTR = TCHAR const*;

inline unsigned GetTickCount() {
	auto time = nn::os::GetSystemTick();
	return static_cast<unsigned>(time.ToTimeSpan().GetMilliSeconds());
}
#else
# error "unknown platform"
#endif

#include <cassert>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <atomic>
#include <chrono>
#if defined(_UNICODE) && !defined(_WIN32)
# include <codecvt>
#endif
#include <condition_variable>
#include <deque>
#include <exception>
#include <fstream>
#include <functional>
#include <future>
#include <iomanip>
#include <ios>
#include <limits>
#include <memory>
#include <mutex>
#include <queue>
#include <random>
#include <regex>
#include <stdexcept>
#include <string>
#include <sstream>
#include <thread>
#include <tuple>
#include <vector>

#ifdef _UNICODE
using tistream = std::wistream;
using tistringstream = std::wistringstream;
using tofstream = std::wofstream;
using tostream = std::wostream;
using tostringstream = std::wostringstream;
using tregex = std::wregex;
using tstringstream = std::wstringstream;
#else
using tistream = std::istream;
using tistringstream = std::istringstream;
using tofstream = std::ofstream;
using tostream = std::ostream;
using tostringstream = std::ostringstream;
using tregex = std::regex;
using tstringstream = std::stringstream;
#endif

#ifdef _DEBUG
# define verify assert
#else
# define verify(expr) ((void)(expr))
#endif

#include "../../base-sdk/Shared/Internal.h"
