// Poly-fill the String trim method.
if (!String.prototype.trim) {
  String.prototype.trim = function() {
    return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
  };
}

// Poly-fill the String startsWith method.
if (!String.prototype.startsWith) {
  String.prototype.startsWith = function(s) {
    return this.substr(0, s.length) === s;
  };
}

// Create the file system object.
var ForReading = 1, ForWriting = 2, ForAppending = 8;
var fso = WScript.CreateObject('Scripting.FileSystemObject');

// Create the output file.
var outputFilePath = WScript.Arguments(1);
var outputFile = fso.CreateTextFile(outputFilePath);
outputFile.WriteLine('// Auto-generated; do not edit');
outputFile.WriteLine('const tests: any[] = [];');

// Transform the input file into the output file.
var inputFilePath = WScript.Arguments(0);
var inputFile = fso.OpenTextFile(inputFilePath, ForReading);
var text = inputFile.ReadAll();

// Complete the output file.
outputFile.WriteLine(text);
outputFile.WriteLine('function test(description: string, fn: any) {');
outputFile.WriteLine('  tests.push({ description, fn });');
outputFile.WriteLine('}');
outputFile.WriteLine('let actualAssertionCount: number;');
outputFile.WriteLine('let hasFailure: boolean = false;');
outputFile.WriteLine('function expect(actual: any) {');
outputFile.WriteLine('  return { toBe: (expected: any) => {');
outputFile.WriteLine('    ++actualAssertionCount;');
outputFile.WriteLine('    if(!Object.is(actual, expected)) {');
outputFile.WriteLine('      consoleError(`==> "${actual}" is not "${expected}"`);');
outputFile.WriteLine('      hasFailure = true;');
outputFile.WriteLine('    }');
outputFile.WriteLine('  } };');
outputFile.WriteLine('}');
outputFile.WriteLine('let expectedAssertionCount: number;');
outputFile.WriteLine('let expectAssertions: boolean;');
outputFile.WriteLine('expect.hasAssertions = () => { expectAssertions = true; };');
outputFile.WriteLine('expect.assertions = (count: number) => {');
outputFile.WriteLine('  expectAssertions = true;');
outputFile.WriteLine('  expectedAssertionCount = count;');
outputFile.WriteLine('};');
outputFile.WriteLine('async function runTests() {');
outputFile.WriteLine('  for(const entry of tests) {');
outputFile.WriteLine('    consoleError(entry.description);');
outputFile.WriteLine('    actualAssertionCount = 0;');
outputFile.WriteLine('    expectedAssertionCount = 0;');
outputFile.WriteLine('    expectAssertions = false;');
outputFile.WriteLine('    await entry.fn();');
outputFile.WriteLine('    if(expectAssertions) {');
outputFile.WriteLine('      if(!actualAssertionCount) {');
outputFile.WriteLine("        consoleError('==> failed to assert');");
outputFile.WriteLine('        hasFailure = true;');
outputFile.WriteLine('      } else if(expectedAssertionCount && expectedAssertionCount !== actualAssertionCount) {');
outputFile.WriteLine("        consoleError(`==> asserted ${actualAssertionCount} times instead of ${expectedAssertionCount} times`);");
outputFile.WriteLine('        hasFailure = true;');
outputFile.WriteLine('      }');
outputFile.WriteLine('    }');
outputFile.WriteLine('  }');
outputFile.WriteLine("  console.log(hasFailure ? 'FAILED' : 'done');");
outputFile.WriteLine('  await new Promise((resolve) => setTimeout(resolve, hasFailure ? 4444 : 999));');
outputFile.WriteLine('}');
outputFile.WriteLine('runTests();');

// Close the files.
inputFile.Close();
outputFile.Close();
