REM Add Visual Studio environment variables if necessary.
IF NOT "%DevEnvDir%" == "" GOTO skip_vsdevcmd
SET V=
FOR /F "delims=" %%I IN ('DIR /B /S "%ProgramFiles(x86)%\Microsoft Visual Studio\VsDevCmd.bat"') DO SET V=%%I
IF "%V%" == "" (
	ECHO Cannot find VsDevCmd.bat.
	EXIT /B 1
)
CALL "%V%"
IF ERRORLEVEL 1 EXIT /B
:skip_vsdevcmd

REM Ensure Python is available.
python --version > NUL 2>&1
IF NOT ERRORLEVEL 1 GOTO skip_python
SET SHARED=%ProgramFiles(x86)%\Microsoft Visual Studio\Shared
PATH %SHARED%\Python37_64;%SHARED%\Python37_64\Scripts;%PATH%
python --version > NUL 2>&1
IF ERRORLEVEL 1 (
	ECHO Cannot find python.
	EXIT /B 1
)
:skip_python

REM Set the temporary environment variable.
SET T=
FOR /F %%I IN ('uuidgen') DO SET T=%TEMP%\%%I
IF "%T%" == "" (
	ECHO Cannot find uuidgen.
	EXIT /B 1
)
