#include "pch.h"
#include "Utilities.h"

using namespace std::literals;
using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

#ifndef _DEBUG
DebugFn test_OutputDebugString;
#endif

std::future<tstring> WindowsLibTest::CreateErrorPromise() {
	static std::promise<tstring> promise;
	promise = std::promise<tstring>();
	struct Local {
		static void OutputDebugString(LPCTSTR s) {
			promise.set_value(s);
			test_OutputDebugString = nullptr;
		}
	};
	test_OutputDebugString = &Local::OutputDebugString;
	return promise.get_future();
}

void WindowsLibTest::AwaitErrorFuture(std::future<tstring>& future, std::chrono::milliseconds timeout /*= 1110ms*/) {
	auto const result = future.wait_for(timeout);
	test_OutputDebugString = nullptr;
	Assert::IsTrue(result != std::future_status::timeout);
}
