#pragma once

#include "../Shared/pch.h"

#ifdef _XBOX_ONE
# include <iostream>
#endif

#if defined(_WIN32) && !defined(_XBOX_ONE)
# include "CppUnitTest.h"
#else
# define TEST_CLASS(className) class className
# define TEST_CLASS_INITIALIZE(methodName) void methodName()
# define TEST_METHOD(methodName) void methodName()

namespace Microsoft {
	namespace VisualStudio {
		namespace CppUnitTestFramework {
			namespace Assert {
				template<typename T, typename U>
				void AreEqual(T expected, U actual) {
					if(expected != actual) {
						throw std::logic_error("equal expectation not met");
					}
				}

				template<typename T, typename U>
				void AreNotEqual(T expected, U actual) {
					if(expected == actual) {
						throw std::logic_error("non-equal expectation not met");
					}
				}

#ifdef _UNICODE
				template<>
				inline void AreEqual(LPCTSTR expected, LPCTSTR actual) {
					if(_tcscmp(expected, actual)) {
						throw std::logic_error("equal expectation not met");
					}
				}

				template<>
				inline void AreNotEqual(LPCTSTR expected, LPCTSTR actual) {
					if(!_tcscmp(expected, actual)) {
						throw std::logic_error("non-equal expectation not met");
					}
				}
#endif

				template<>
				inline void AreEqual(char const* expected, char const* actual) {
					if(std::strcmp(expected, actual)) {
						throw std::logic_error("equal expectation not met");
					}
				}

				template<>
				inline void AreNotEqual(char const* expected, char const* actual) {
					if(!std::strcmp(expected, actual)) {
						throw std::logic_error("non-equal expectation not met");
					}
				}

				inline void IsFalse(bool value) {
					if(value) {
						throw std::logic_error("false expectation not met");
					}
				}

				inline void IsTrue(bool value) {
					if(!value) {
						throw std::logic_error("true expectation not met");
					}
				}

				inline void Fail(Twitch::tstring const& message) {
#ifdef _XBOX_ONE
# pragma warning(push)
# pragma warning(disable: 4244)
#endif
					throw std::logic_error(std::string(message.cbegin(), message.cend()));
#ifdef _XBOX_ONE
# pragma warning(pop)
#endif
				}

				template<typename T>
				void ExpectException(std::function<void()> fn) {
					try {
						fn();
					} catch(T const&) {
						return;
					}
					throw std::logic_error("exception expectation not met");
				}
			}

			namespace Logger {
				inline void WriteMessage(char const* message) {
					std::cout << "LOG:  " << message << std::endl;
				}
			}
		}
	}
}
#endif
