'use strict';

const express = require('express');
const path = require('path');
const { createServer } = require('http');
const WebSocket = require('ws');

const app = express();
app.use(express.static(path.join(__dirname, '/public')));

let restarted = false;
const server = createServer(app);
createWebSocketServer();

const port = 6006;
server.listen(port, () => {
  console.log(`Listening on http://localhost:${port}`);
});

function createWebSocketServer() {
  const wss = new WebSocket.Server({ server });

  wss.on('connection', (ws, request) => {
    const id = `${request.socket.remoteAddress}:${request.socket.remotePort}`;
    const state = { isConnected: false, data: {} };
    console.log('client connected', id);
    ws.on('message', (data) => {
      console.log(`received:  ${data}`);
      try {
        const message = JSON.parse(data);
        if(message.connect) {
          validateConnectMessage(message);
          if(message.connect.token === 'bad-token') {
            const errorMessage = {
              error: {
                code: 'connect_invalid_token',
                message: 'Auth token not valid.',
              },
            };
            ws.send(JSON.stringify(errorMessage));
          } else if(message.connect.token === 'invalid-json') {
            ws.send('$');
          } else if(message.connect.token === 'unexpected-json') {
            ws.send('1');
          } else {
            ws.send(JSON.stringify({ connected: true }));
            state.data = message.connect.data;
            state.isConnected = true;
            if(message.connect.token === 'abort' || message.connect.token.startsWith('restart-')) {
              if(restarted) {
                restarted = false;
                const errorMessage = {
                  error: {
                    code: 'connect_invalid_token',
                    message: 'Auth token not valid.',
                  },
                };
                ws.send(JSON.stringify(errorMessage));
              } else {
                restarted = true;
                console.log(message.connect.token);
                if(message.connect.token === 'abort') {
                  console.log('abort');
                  wss.close();
                  createWebSocketServer();
                } else {
                  ws.send(JSON.stringify({ reconnect: message.connect.token.endsWith('-long') ? 2200 : 110 }));
                  wss.close();
                  createWebSocketServer();
                }
              }
            } else {
              ws.send('"connected"');
            }
          }
        } else if(message.refresh) {
          state.data = message.refresh.data;
          ws.send(JSON.stringify(message));
        } else {
          ws.send(JSON.stringify(message));
        }
      } catch(ex) {
        console.log(ex);
        const errorMessage = {
          error: {
            code: 'bad_data_packet',
            message: 'Bad data packet for parsing either in connection or delta.',
          },
        };
        ws.send(JSON.stringify(errorMessage));
      }
    });
    ws.on('close', () => {
      console.log('client disconnected');
    });
  });
}

function validateConnectMessage(message) {
  if(!message.connect) {
    throw new Error('no "connect" field');
  }
  ['token', 'broadcaster_ids', 'game_id', 'env', 'data'].forEach((name) => {
    if(!message.connect[name]) {
      throw new Error(`no "connect.${name}" field`);
    }
  });
}
