@ECHO OFF
SETLOCAL

REM Check usage.
IF NOT "%~1" == "ORBIS" GOTO usage
IF NOT "%~2" == "Debug" IF NOT "%~2" == "Release" GOTO usage
IF NOT "%~3" == "" IF NOT "%~3" == "rebuild" GOTO usage
IF NOT "%~4" == "" GOTO usage

REM Set environment variables.
SET PLATFORM=%~1
SET CONFIGURATION=%~2
SET INTERMEDIATE_DIRECTORY=%~dp0%PLATFORM%\%CONFIGURATION%
IF NOT EXIST "%INTERMEDIATE_DIRECTORY%" (
	ECHO Cannot find intermediate directory
	EXIT /B 1
)
SET MBEDTLS_DIRECTORY=%~dp0..\vendor\mbedtls
IF "%PLATFORM%" == "ORBIS" (
	SET ARG=ps4
	SET BUILD_DIRECTORY=%MBEDTLS_DIRECTORY%\ps4\VS2017
	SET X=a
)
SET PROJECT_FILE=mbedTLS.vcxproj

REM Check if this needs to run.
IF EXIST "%INTERMEDIATE_DIRECTORY%\mbedTLS.a" (
	ECHO Skipping build of mbedTLS.
	EXIT /B
)

REM Add Visual Studio environment variables.
SET V=
FOR /F "delims=" %%I IN ('DIR /B /S "%ProgramFiles(x86)%\Microsoft Visual Studio\VsDevCmd.bat"') DO SET V=%%I
IF "%V%" == "" (
	ECHO Cannot find VsDevCmd.bat.
	EXIT /B 1
)
CALL "%V%"
IF ERRORLEVEL 1 EXIT /B

REM Build mbedTLS.
CD "%BUILD_DIRECTORY%"
MSBuild %PROJECT_FILE% /m "/p:Platform=%PLATFORM%" "/p:Configuration=%CONFIGURATION%"
IF ERRORLEVEL 1 EXIT /B

REM Ensure a consistent output library file name.
COPY /Y "%BUILD_DIRECTORY%\%PLATFORM%\%CONFIGURATION%\mbedTLS.a" "%INTERMEDIATE_DIRECTORY%"
EXIT /B

:usage
ECHO.
ECHO usage: %~nx0 configuration [rebuild]
ECHO.
ECHO Specify configuration as either "Debug" or "Release".
ECHO Specify "rebuild" to recreate the Player Core build files.
EXIT /B 1
