// Poly-fill the String trim method.
if(!String.prototype.trim) {
  String.prototype.trim = function() {
    return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
  };
}

// Poly-fill the String startsWith method.
if(!String.prototype.startsWith) {
  String.prototype.startsWith = function(s) {
    return this.substr(0, s.length) === s;
  };
}

// Create the file system object.
var ForReading = 1, ForWriting = 2, ForAppending = 8;
var fso = WScript.CreateObject('Scripting.FileSystemObject');

// Create the output file.
var outputFilePath = WScript.Arguments(1);
var outputFile = fso.CreateTextFile(outputFilePath);
outputFile.WriteLine('// Auto-generated; do not edit');
outputFile.WriteLine('let hasFailure = false;');

// Transform the input file into the output file.
var inputFilePath = WScript.Arguments(0);
var inputFile = fso.OpenTextFile(inputFilePath, ForReading);
var n = 0, m, hasBeforeAll = false, hasAfterAll = false, isInTest = false;
var rx = /(\s*)expect\((.+)\).toBe\((.+)\)/;
while(!inputFile.AtEndOfStream) {
  var line = inputFile.ReadLine();
  if(line.trim().startsWith('console.error(')) {
    line = line.replace("('", "('==> ");
  }
  if(line.trim().startsWith('test(')) {
    outputFile.WriteLine('async function f' + n + '() {');
    outputFile.WriteLine("  console.log('" + line.split("'")[1] + "');");
    outputFile.WriteLine('  try {');
    ++n;
    m = '';
    isInTest = true;
  } else if(line.trim().startsWith('beforeAll(')) {
    outputFile.WriteLine('async function beforeAll() {');
    outputFile.WriteLine('  try {');
    hasBeforeAll = true;
  } else if(line.trim().startsWith('afterAll(')) {
    outputFile.WriteLine('async function afterAll() {');
    outputFile.WriteLine('  try {');
    hasAfterAll = true;
  } else if(line.trim().startsWith('expect')) {
    line = rx.exec(line);
    if(line) {
      outputFile.WriteLine(line[1] + '  const result' + m + ' = ' + line[2] + ';');
      outputFile.WriteLine(line[1] + '  if(result' + m + ' !== ' + line[3] + ') {');
      outputFile.WriteLine(line[1] + "    console.error('==> unexpected value:', result" + m + ');');
      outputFile.WriteLine(line[1] + "    hasFailure = true;");
      outputFile.WriteLine(line[1] + '  }');
      m += '_';
    }
  } else if(line === '});') {
    outputFile.WriteLine('  } catch(ex) {');
    outputFile.WriteLine("    console.error('==> unexpected exception:', ex);");
    outputFile.WriteLine("    hasFailure = true;");
    outputFile.WriteLine('  }');
    outputFile.WriteLine('}');
    isInTest = false;
  } else if(~line.indexOf('../lib/index')) {
    outputFile.WriteLine(line.replace('../lib/index', './lib/index'));
  } else if(isInTest && line.trim()) {
    outputFile.WriteLine('  ' + line);
  } else {
    outputFile.WriteLine(line);
    if(~line.indexOf('console.error') && isInTest) {
      outputFile.WriteLine('  ' + line.replace(/[^ ].*/, '') + 'hasFailure = true;');
    }
  }
}

// Complete the output file.
outputFile.WriteLine('async function runTests() {');
if(hasBeforeAll) {
  outputFile.WriteLine('  await beforeAll();');
}
for(var i = 0; i < n; ++i) {
  outputFile.WriteLine('  await f' + i + '();');
}
if(hasAfterAll) {
  outputFile.WriteLine('  await afterAll();');
}
outputFile.WriteLine("  console.log(hasFailure ? 'FAILED' : 'done');");
outputFile.WriteLine('  await new Promise((resolve) => setTimeout(resolve, hasFailure ? 4444 : 999));');
outputFile.WriteLine('}');
outputFile.WriteLine('runTests();');

// Close the files.
inputFile.Close();
outputFile.Close();
