#pragma once

#include <cstdint>
#include <memory>
#include "Twitch.h"

class Surface {
public:
	virtual void SetPlayer(std::shared_ptr<Twitch::Player> player) = 0;

	__declspec(property(put = SetPlayer)) std::shared_ptr<Twitch::Player> Player;
};

class MyDisplay {
public:
	struct RenderStruct {
		void* frameBuffer = nullptr;
		uint32_t width = 0;
		uint32_t height = 0;
		uint32_t pitch = 0;
		uint32_t cropLeft;
		uint32_t cropRight;
		uint32_t cropTop;
		uint32_t cropBottom;
	};

	static MyDisplay* create();
	virtual ~MyDisplay();
	virtual int initialize() = 0;
	virtual void finalize() = 0;
	virtual void update() = 0;
	virtual void render() = 0;
	virtual Surface* getSurface(uint32_t index) = 0;
	virtual void toggleSplitView() = 0;
};
