#include "pch.h"
#include "NativePlayer.h"
#include "Display.h"

// For sample framework
#define MY_DISPLAY_WIDTH 1920
#define MY_DISPLAY_HEIGHT 1080

int NativePlayer::initialize() {
	int32_t ret = 0;
	ret = initializeUtil(kFunctionFlagPadOfInitialUser | kFunctionFlagUserIdManager, MY_DISPLAY_WIDTH,
		MY_DISPLAY_HEIGHT);

	if(ret < 0) {
		printf("sceSysmoduleLoadModule:0x%08x failed.\n", ret);
		return ret;
	}

	if(ret < 0) {
		printf("mp_frames->initialize:0x%08x failed.\n", ret);
		return ret;
	}

	mp_display = MyDisplay::create();
	ret = mp_display->initialize();
	if(ret < 0) {
		printf("mp_display->initialize:0x%08x failed.\n", ret);
	}

	return ret;
}

int NativePlayer::update() {
	auto ret = updateUtil();
	if(ret != SCE_OK) {
		return ret;
	}

	mp_display->update();
	return ret;
}

void NativePlayer::render() {
	mp_display->render();
}

int NativePlayer::run() {
	// 60 FPS => 16 msec period
	auto period = std::chrono::milliseconds(16);

	using Clock = std::chrono::high_resolution_clock;
	Clock::time_point start, end;

	int ret = 0;

	while(true) {
		{
			std::lock_guard<std::mutex> lock(m_mutex);
			if(m_state != State::Running) {
				break;
			}
		}

		start = Clock::now();
		ret = update();

		if(ret < 0) {
			break;
		}

		render();

		// Measure elapsed time to sleep
		end = Clock::now();
		auto elapsed = end - start;
		if(elapsed < period) {
			std::this_thread::sleep_for(period - elapsed);
		}
	}

	std::lock_guard<std::mutex> lock(m_mutex);
	m_state = State::Stopped;
	m_condition.notify_one();
	return ret;
}

void NativePlayer::stop() {
	std::unique_lock<std::mutex> lock(m_mutex);
	m_state = State::Stopping;
	m_condition.wait(lock, [this]() { return m_state == State::Stopped; });
}

int NativePlayer::finalize() {
	mp_display->finalize();

	auto code = finalizeUtil();
	if(code != 0) {
		printf("finalizeUtil:0x%08x failed.\n", code);
	}
	return code;
}
