#pragma once

#include <condition_variable>
#include <memory>
#include <mutex>
#include <sampleutil.h>
#include "Twitch.h"

class MyDisplay;

class NativePlayer : public sce::SampleUtil::SampleSkeleton {
public:
	// SampleSkeleton overrides
	int initialize() override;
	int update() override;
	void render() override;
	int finalize() override;
	virtual int run();
	virtual void stop();
	MyDisplay* display() { return mp_display; }

protected:
	enum class State {
		Running,
		Stopping,
		Stopped,
	};

	std::mutex m_mutex;
	std::condition_variable m_condition;
	MyDisplay* mp_display;
	State m_state = State::Running;
};
