#include "pch.h"
#include "StreamPlayer.h"

using namespace Twitch;

StreamPlayer::StreamPlayer(Listener& listener, Surface* surface, Configuration config)
	: m_listener(listener)
	, m_player(std::make_shared<Player>(*this))
	, m_config(config) {
	assert(m_player);
	surface->Player = m_player;
}

void StreamPlayer::load(const std::string& url) {
	m_streamStarted = false;
	m_player->Load(url);
}

void StreamPlayer::pause() {
	if(m_streamStarted) {
		m_player->Pause();
	}
}

void StreamPlayer::play() {
	if(m_streamStarted) {
		m_player->Play();
	}
}

void StreamPlayer::seekBackwards(double time) {
	if(!m_streamStarted || !m_player->IsSeekable) {
		return;
	}

	double currentPosition = m_player->Position;
	double seekPosition = currentPosition - time;
	seekPosition = std::max(seekPosition, 0.0);
	if(seekPosition != currentPosition) {
		m_player->Position = seekPosition;
	}
}

void StreamPlayer::seekForwards(double time) {
	if(!m_streamStarted || !m_player->IsSeekable) {
		return;
	}

	double currentPosition = m_player->Position;
	double seekPosition = currentPosition + time;
	seekPosition = std::min(seekPosition, m_player->Duration);
	if(seekPosition != currentPosition) {
		m_player->Position = seekPosition;
	}
}

void StreamPlayer::setNextQuality() {
	if(!m_streamStarted) {
		return;
	}

	//const auto& currentQuality = m_player->getQuality();
	//const auto& availableQualities = m_player->getQualities();

	//auto itr = std::find(availableQualities.begin(), availableQualities.end(), currentQuality);

	//// couldn't even find your own quality, what ?
	//if (itr == availableQualities.end()) {
	//    return;
	//}

	//// cycle to the next
	//++itr;
	//if (itr == availableQualities.end()) {
	//    itr = availableQualities.begin();
	//}

	//m_player->setQuality(*itr);
}

void StreamPlayer::setAuthToken(const std::string& token) {
	//m_player->setAuthToken(token);
}

void StreamPlayer::OnDurationChanged(double duration) {
	printf("onDurationChanged to %f\n", duration);
}

void StreamPlayer::OnError(Twitch::tstring const& error) {
	printf("onError %s\n", error.c_str());
}

//void StreamPlayer::onQualityChanged(const Quality& quality)
//{
//    printf("onQualityChanged to %s, bitrate:%d, height:%d, width:%d, group:%s, isDefault:%s, autoSelect:%s\n",
//        quality.name.c_str(), quality.bitrate, quality.height, quality.width, quality.group.c_str(), quality.isDefault ? "true" : "false", quality.autoSelect ? "true" : "false");
//}

void StreamPlayer::OnSeekCompleted(double time) {
	printf("onSeekCompleted %f s\n", time);
}

void StreamPlayer::OnStateChanged(Player::PlayerState state) {
	m_state = state;
	if(m_state == Player::PlayerState::Ready) {
		if(m_config.defaultInitialQuality) {
			setInitialQuality();
		}

		if(m_config.initialSeekTime > 0.0 && m_player->IsSeekable) {
			m_player->Position = m_config.initialSeekTime;
		}

		m_player->Play();
		m_streamStarted = true;
		m_listener.onStreamStarted();
	}
}

void StreamPlayer::setInitialQuality() {
	//const auto& qualities = m_player->getQualities();
	//assert(!qualities.empty());

	//auto itr = std::find_if(qualities.begin(), qualities.end(), [](const Quality& quality) { return quality.isDefault; });
	//if (itr == qualities.end()) {
	//    // If the default quality could not be found, use the first quality
	//    m_player->setQuality(qualities.front());
	//} else {
	//    m_player->setQuality(*itr);
	//}
}
