#pragma once

#include "Twitch.h"
#include "Display.h"

class StreamPlayer : public Twitch::Player::Observer {
public:
	using AccessFn = Twitch::Player::AccessFn;

	// Listener to notify when a stream has started after loading
	struct Listener {
		virtual void onStreamStarted() = 0;
	};

	struct Configuration {
		Configuration() {}

		// If enabled, each stream will set its initial quality to the default quality
		bool defaultInitialQuality = false;

		// The initial time to seek to when a stream is ready
		double initialSeekTime = 0.0;
	};

	StreamPlayer(Listener& listener, Surface* surface, Configuration config = Configuration());

	const Twitch::Player& getPlayer() const { return *m_player; }
	Twitch::Player& getPlayer() { return *m_player; }

	// Player controls
	void load(const std::string& url);
	void pause();
	void play();
	void seekBackwards(double time);
	void seekForwards(double time);
	double getPosition() { return m_player->Position; }
	void setNextQuality();
	void setAuthToken(const std::string& token);

	// Player::Observer overrides
	void OnDurationChanged(double) override;
	void OnError(Twitch::tstring const&) override;
	//void OnQualityChanged(const twitch::Quality&) override;
	void OnRebuffering() override {}
	void OnSeekCompleted(double time) override;
	void OnStateChanged(Twitch::Player::PlayerState) override;
	void OnPositionChanged(double) override {}

private:
	void setInitialQuality();

	Listener& m_listener;
	std::shared_ptr<Twitch::Player> m_player;
	Configuration m_config;

	Twitch::Player::PlayerState m_state = Twitch::Player::PlayerState::Idle;
	bool m_streamStarted = false;
};
