#pragma once

#include "Display.h"
#include <gnm/texture.h>
#include <gnmx/gfxcontext.h>
#include <mutex>

class View : public Surface {
public:
	// Used to pass as shader parameter
	enum class DisplayMode {
		Disabled = -1,
		FullScreen = 0,
		SplitLeft = 1,
		SplitRight = 2
	};

	void draw(sce::Gnmx::GfxContext* context);
	void SetPlayer(std::shared_ptr<Twitch::Player> player) override { m_player = player; }
	bool update();
	void setDisplayMode(DisplayMode mode) { m_mode = mode; }

private:
	DisplayMode m_mode;
	sce::Gnm::Texture m_lumaTexture;
	sce::Gnm::Texture m_chromaTexture;
	std::mutex m_mutex;

	std::shared_ptr<Twitch::Player> m_player;
	bool draw(SceVideodec2OutputInfo const& outputInfo, SceVideodec2AvcPictureInfo const& pictureInfo, sce::Gnmx::GfxContext* context);
	bool update(SceVideodec2OutputInfo const& outputInfo, SceVideodec2AvcPictureInfo const& pictureInfo);
};
