#include "pch.h"
#include <libnetctl.h>
#include <libsecure.h>
#include <sce_random.h>

#pragma comment(lib, "SceNetCtl_stub_weak")
#pragma comment(lib, "SceRandom_stub_weak")
#pragma comment(lib, "SceSecure")
#pragma comment(lib, "SceSysmodule_stub_weak")

using namespace Twitch;

constexpr std::chrono::seconds DataSource::Configuration::DefaultTimeout /*= std::chrono::seconds(10)*/;

namespace {
	SceLibSecureErrorType Initialize() {
		// Load Sony's Random module, use it to generate a seed, and initialize
		// Sony's Secure library with it.
		int loadResult = sceSysmoduleLoadModule(SCE_SYSMODULE_RANDOM);
		static char buffer[4160];
		int randomResult = sceRandomGetRandomNumber(buffer, SCE_RANDOM_MAX_SIZE);
		SceLibSecureBlock initialBlock{ buffer, sizeof(buffer) };
		SceLibSecureErrorType const secureResult = sceLibSecureInit(SCE_LIBSECURE_FLAGS_RANDOM_GENERATOR, &initialBlock);
		UNREFERENCED_PARAMETER(loadResult);
		UNREFERENCED_PARAMETER(randomResult);
		return secureResult;
	}
}

tstring Twitch::GetDeviceId() {
	// TODO:  document this TRC requirement.
	// https://ps4.siedev.net/resources/documents/TRC/2018.02/TRC/R4081.html
	union {
		SceNetCtlInfo info;
		unsigned short n[3];
	} u{};
	static_assert(sizeof(u.info.ether_addr) == sizeof(u.n), "unexpected size");
	if(sceNetCtlGetInfo(SCE_NET_CTL_INFO_ETHER_ADDR, &u.info) == 0 && (u.n[0] || u.n[1] || u.n[2])) {
		TCHAR deviceId[37];
		_stprintf_s(deviceId, _T("00000000-%04x-%04x-%04x-000000000000"), u.n[0], u.n[1], u.n[2]);
		return deviceId;
	}
	return tstring();
}

void Twitch::rand_s(unsigned* p) {
	// Initialize Sony's Secure library.
	static SceLibSecureErrorType result = Initialize();
	UNREFERENCED_PARAMETER(result);

	// Use it to generate a cryptographically secure random number.  Failing
	// that, use the C library's random number generation function.
	SceLibSecureBlock block{ p, sizeof(*p) };
	if(sceLibSecureRandom(&block) != SCE_LIBSECURE_OK) {
		*p = rand();
	}
}
