@ECHO OFF
SETLOCAL

REM Check usage.
IF NOT "%~1" == "ORBIS" IF NOT "%~1" == "x64" GOTO usage
IF NOT "%~2" == "Debug" IF NOT "%~2" == "Release" GOTO usage
IF NOT "%~3" == "" IF NOT "%~3" == "rebuild" GOTO usage
IF NOT "%~4" == "" GOTO usage
IF NOT EXIST "%~dp0%1\%2" (
	ECHO Cannot find output directory
	EXIT /B 1
)

REM Set environment variables.
SET PLATFORM=%~1
SET CONFIGURATION=%~2
SET PLAYER_CORE_DIRECTORY=%~dp0..\vendor\player-core
IF "%PLATFORM%" == "ORBIS" (
	SET ARG=ps4
	SET BUILD_DIRECTORY=%PLAYER_CORE_DIRECTORY%\build\ps4\6.500
	SET X=a
) ELSE IF "%PLATFORM%" == "x64" (
	SET ARG=win64
	SET BUILD_DIRECTORY=%PLAYER_CORE_DIRECTORY%\build\windows\Win64
	SET X=lib
)
IF "%PLATFORM%" == "ORBIS" (
	SET OUTPUT_DIRECTORY=%BUILD_DIRECTORY%\lib\%CONFIGURATION%
) ELSE IF "%PLATFORM%" == "x64" (
	SET OUTPUT_DIRECTORY=%BUILD_DIRECTORY%\lib\x64\%CONFIGURATION%
)
IF "%CONFIGURATION%" == "Debug" (
	SET D=d
) ELSE (
	SET D=
)
SET PROJECT_FILE=playercore.vcxproj

REM Check if this needs to run.
IF EXIST "%OUTPUT_DIRECTORY%\playercore.%X%" (
	ECHO Skipping build of PlayerCore.
	EXIT /B
)

REM Add Visual Studio environment variables.
SET V=
FOR /F "delims=" %%I IN ('DIR /B /S "%ProgramFiles(x86)%\Microsoft Visual Studio\VsDevCmd.bat"') DO SET V=%%I
IF "%V%" == "" (
	ECHO Cannot find VsDevCmd.bat.
	EXIT /B 1
)
CALL "%V%"
IF ERRORLEVEL 1 EXIT /B

REM Create Player Core projects, if necessary.
IF EXIST "%BUILD_DIRECTORY%\%PROJECT_FILE%" IF "%~3" == "" GOTO skip_create
CD "%PLAYER_CORE_DIRECTORY%\scripts\tc"
SET CMAKE_WINDOWS_KITS_10_DIR=%ProgramFiles(x86)%\Windows Kits\10
FOR /F %%I IN ('DIR /B "%CMAKE_WINDOWS_KITS_10_DIR%\Include"') DO SET CMAKE_SYSTEM_VERSION=%%I
SET CMAKE_VS_WINDOWS_TARGET_PLATFORM_VERSION=%CMAKE_SYSTEM_VERSION%
CALL createprojects.cmd /%ARG%
IF ERRORLEVEL 1 EXIT /B
IF "%PLATFORM%" == "x64" (
	cscript //nologo "%~dpn0.js" "%BUILD_DIRECTORY%\platforms\windows\platforms_obj.vcxproj"
	IF ERRORLEVEL 1 EXIT /B
)
:skip_create

REM Build Player Core.
CD "%BUILD_DIRECTORY%"
MSBuild %PROJECT_FILE% /m "/p:Platform=%PLATFORM%" "/p:Configuration=%CONFIGURATION%"
IF "%PLATFORM%" == "ORBIS" (
	IF NOT ERRORLEVEL 1 CALL :build_ps4_vendor dbg_font
	IF NOT ERRORLEVEL 1 CALL :build_ps4_vendor framework
	IF NOT ERRORLEVEL 1 CALL :build_ps4_vendor libSceSampleUtil.sln "%PLAYER_CORE_DIRECTORY%\vendor\ps4samples\sampleutil\source\sampleutil"
	IF NOT ERRORLEVEL 1 CALL :build_ps4_vendor toolkit
)
IF ERRORLEVEL 1 EXIT /B

REM Copy dependencies with consistent library file names.
FOR %%I IN (caption json11) DO COPY /Y "%BUILD_DIRECTORY%\external\lib\%%I%D%.%X%" "%~dp0%PLATFORM%\%CONFIGURATION%\%%I.%X%"

REM Ensure a consistent output library file name.
IF NOT "%CONFIGURATION%" == "Debug" EXIT /B
FOR /F %%I IN ('DIR /B /OD "%OUTPUT_DIRECTORY%\playercore*"') DO SET FILE_NAME=%%~nI
IF "%FILE_NAME%" == "playercored" COPY /Y "%OUTPUT_DIRECTORY%\playercored.%X%" "%OUTPUT_DIRECTORY%\playercore.%X%"
EXIT /B

:build_ps4_vendor
IF "%~2" == "" (
	CD "%PLAYER_CORE_DIRECTORY%\vendor\ps4samples\%~1"
	SET BUILD_FILE="%~1.vcxproj"
) ELSE (
	CD %2
	SET BUILD_FILE=%1
)
MSBuild %BUILD_FILE% /m "/p:Platform=%PLATFORM%" "/p:Configuration=%CONFIGURATION%"
EXIT /B

:usage
ECHO.
ECHO usage: %~nx0 configuration [rebuild]
ECHO.
ECHO Specify configuration as either "Debug" or "Release".
ECHO Specify "rebuild" to recreate the Player Core build files.
EXIT /B 1
