#include "pch.h"
#include "Internal.h"
#include "Twitch.h"

using namespace Twitch;

std::future<tstring> Twitch::ApplicationAuth::StartAuth(tstring const& clientId, tstring const& clientSecret, tstring const& scopes) {
	auto fn = [clientId, clientSecret, scopes]() {
		// Compose the authentication URL.
		auto url = _T("https://id.twitch.tv/oauth2/token?client_id=") + clientId +
			_T("&client_secret=") + clientSecret + _T("&grant_type=client_credentials");
		auto httpResponse = HttpRequest().Post(url);
		ThrowIfResponseFailed(httpResponse);

		// Parse the response as JSON.
		auto response = httpResponse.Response;
		std::string parseError;
		auto jsonVal = json11::Json::parse(std::string(response.cbegin(), response.cend()).c_str(), parseError);
		if(!parseError.empty()) {
			DebugWriteLine(_T("[ApplicationAuth::StartAuth] JSON parsing failed:  %s"), ToTstring(parseError).c_str());
			throw TwitchException(FromPlatformError(ERROR_INVALID_RESPONSE));
		}

		// Send a science event.
		SendUserScienceEvent(clientId, tstring(), _T("sdk_auth_sign_in"), { { _T("scopes"), scopes }, { _T("type"), _T("server") } });

		// Return the access_token field value.
		return ToTstring(jsonVal["access_token"].string_value());
	};
	return std::async(std::launch::deferred, fn);
}
