#pragma once

#include "Http.h"


namespace Twitch {
	tstring BuildUrlEncodedRequestParams(std::vector<std::pair<tstring, tstring>> const& requestParams);
	tstring BuildUrlEncodedRequestParams(std::vector<HttpParam> const& requestParams);
	tstring BuildUrlEncodedRequestParams(stringmap const& requestParams);
	tstring BuildHttpHeader(std::vector<HttpParam> const& headerParams);
	bool ContainsHttpParameter(std::vector<HttpParam> const& headers, tstring const& name);
	void UrlEncode(tstring const& inputString, tstringstream& outputStream);
	tstring UrlEncode(tstring const& inputString);
	void UrlDecode(tstring const& inputString, tstringstream& outputStream);
	void UrlDecode(tstring const& input, tstring& result);
	tstring UrlDecode(tstring const& inputString);

	int SplitHttpParameters(tstring const& parameterString, std::vector<std::pair<tstring, tstring>>& result);
	int SplitHttpParameters(tstring const& parameterString, stringmap& result);

	void ParseHeaders(string_t const raw, size_t size, stringmap& headers);
	void ParseHeaders(string_t const raw, stringmap& headers);

	class Uri;
}


class Twitch::Uri {
public:
	Uri();
	Uri(tstring const& url);

	void SetUrl(tstring const& url);
	tstring GetUrl() const;

	tstring GetResource() const { return mPath + queryString; }

	tstring GetPath() const { return mPath; }
	void GetPathComponents(std::vector<tstring>& result) const;
	void SetPath(tstring const& path) { mPath = path; }

	tstring GetProtocol() const { return mProtocol; }
	void SetProtocol(tstring const& protocol) { mProtocol = protocol; }

	tstring GetHostName() const { return mHostName; }
	void SetHostName(tstring const& host) { mHostName = host; }

	tstring GetPort() const { return mPort; }
	void SetPort(tstring const& port) { mPort = port; }

	bool GetPort(uint16_t& result) const;

	void ClearParams();
	void SetParam(tstring const& param, string_t value);
	void SetParam(tstring const& param, tstring const& value);
	void SetParam(tstring const& param, uint32_t value);
	void SetParam(tstring const& param, int32_t value);
	void SetParam(tstring const& param, uint64_t value);
	void SetParam(tstring const& param, int64_t value);
	void SetParam(tstring const& param, bool value);

	stringmap& GetParams() { return mParams; }
	stringmap const& GetParams() const { return mParams; }

	bool ContainsParam(tstring const& param) const;

	operator tstring() const;
	bool operator==(Uri const& other) const;
	bool operator!=(Uri const& other) const;

private:
	void DisassembleUrl(tstring const& url);
	tstring AssembleUrl() const;

	tstring mProtocol;
	tstring mHostName;
	tstring mPort;
	tstring mPath;
	tstring queryString;
	stringmap mParams;
};
