namespace {
	struct ListenerImpl : public twitch::Player::Listener {
		using Observer = Twitch::Player::Observer;

		ListenerImpl(Observer& observer) : observer(observer) {}

		Observer& observer;

		void onDurationChanged(twitch::MediaTime duration) override { observer.OnDurationChanged(duration.seconds()); }
		void onError(twitch::Error const& error) override { observer.OnError(ToTstring(error.message)); }
		void onMetadata(std::string const&, std::vector<uint8_t> const&) override {}
		void onPositionChanged(twitch::MediaTime position) override { observer.OnPositionChanged(position.seconds()); }
		void onQualityChanged(twitch::Quality const&) override {}
		void onRebuffering() override { observer.OnRebuffering(); }
		void onRecoverableError(twitch::Error const&) override {}
		void onSeekCompleted(twitch::MediaTime time) override { observer.OnSeekCompleted(time.seconds()); }
		void onStateChanged(twitch::Player::State state) override { observer.OnStateChanged(static_cast<Player::PlayerState>(state)); }
		void onAnalyticsEvent(std::string const&, std::string const&) override {}
	};
}
