#pragma once

#ifdef _WIN32
# include <WinSock2.h>
# include <WS2tcpip.h>
#elif defined(__ORBIS__)
# include <net.h>
#endif

#include "Socket.h"

namespace Twitch {
#ifdef _WIN32
	using socket_t = SOCKET;
#elif defined(__ORBIS__)
	using socket_t = SceNetId;
#else
# error "unknown platform"
#endif

	struct SecureSocket : public Socket {
	public:
		SecureSocket();
		SecureSocket(SecureSocket const&) = delete;
		SecureSocket(SecureSocket&& that);
		SecureSocket& operator=(SecureSocket const&) = delete;
		SecureSocket& operator=(SecureSocket&& that) = delete;
		~SecureSocket();

	protected:
		void InternalClose() noexcept override;
		int InternalConnect(string_t hostName, unsigned short port, std::chrono::milliseconds timeout) noexcept override;
		int InternalReceive(void* buffer, size_t size) noexcept override;
		int InternalSend(void const* buffer, size_t size) noexcept override;

	private:
		struct SecureSocketImpl;

		std::unique_ptr<SecureSocketImpl> pimpl;
	};
}
