#pragma once

namespace Twitch {
	struct Socket {
	public:
		static constexpr std::chrono::seconds DefaultTimeout = std::chrono::seconds(10);

		virtual ~Socket() = 0;
		void Close() noexcept { return InternalClose(); }
		int Connect(string_t hostName, unsigned short port, std::chrono::milliseconds timeout = DefaultTimeout) noexcept { return InternalConnect(hostName, port, timeout); }
		int Receive(void* buffer, size_t size) noexcept { return InternalReceive(buffer, size); }
		template<typename T>
		int ReceiveAll(T& buffer) noexcept {
			for(decltype(buffer.size()) i = 0; i < buffer.size();) {
				auto result = Receive(&buffer[i], buffer.size() - i);
				if(result > 0) {
					i += result;
				} else {
					return result;
				}
			}
			return static_cast<int>(buffer.size());
		}
		int Send(void const* buffer, size_t size) noexcept { return InternalSend(buffer, size); }
		template<typename T>
		int Send(T const& buffer) noexcept { return buffer.empty() ? 0 : Send(&buffer[0], buffer.size()); }
		int SendAll(void const* buffer, size_t size) noexcept {
			for(decltype(size) i = 0; i < size;) {
				auto const result = Send(reinterpret_cast<char const*>(buffer) + i, size - i);
				if(result > 0) {
					i += result;
				} else {
					return result;
				}
			}
			return static_cast<int>(size);
		}
		template<typename T>
		int SendAll(T const& buffer) noexcept { return buffer.empty() ? 0 : SendAll(&buffer[0], buffer.size()); }

	protected:
		virtual void InternalClose() noexcept = 0;
		virtual int InternalConnect(string_t hostName, unsigned short port, std::chrono::milliseconds timeout) noexcept = 0;
		virtual int InternalReceive(void* buffer, size_t size) noexcept = 0;
		virtual int InternalSend(void const* buffer, size_t size) noexcept = 0;
	};
}
