#pragma once

namespace Twitch {
	// Represents an absolute time in seconds since epoch.
	using Timestamp = uint32_t;

	bool IsValidChannelName(tstring const& channelName);
	bool IsValidUserName(tstring const& userName);
	bool IsValidOAuthToken(tstring const& oauthToken);
	int IsWhitespace(int ch);
	tstring ToLowerCase(tstring const& str);
	void Trim(tstring& str);
	void Split(tstring const& str, std::vector<tstring>& result, TCHAR sep, bool includeEmpty);
	void Split(tstring const& str, tstring const& delim, std::vector<tstring>& result);
	bool StartsWith(tstring const& str, tstring const& prefix);
	bool EndsWith(tstring const& str, tstring const& suffix);
	bool RFC3339TimeToUnixTimestamp(std::string const& str, Timestamp& result);

	/**
	* A better string copying function which guarantees null termination of the destination.
	* Some platform versions of _sntprintf don't handle all cases as expected.
	*/
	void SafeStringCopy(LPTSTR dst, string_t src, size_t maxLen);

	/**
	* Generates a 32 character random string.
	*/
	tstring GetGuid();

	std::vector<tstring> ParseArguments(tstring args);
}
